/* eslint-disable no-global-assign */
/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于找卡界面(与大屏连接挂钩)
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2022.01.21
 *      内容 : 所有代码
 *************************************************************************************************/


/* exported get_side_data */
/* exported mc_init */
/* exported mc_get_box */
/* exported check0 */
/* exported check1 */
/* exported check2 */
/* exported check3 */
/* exported check4 */
/* exported mc_send */
/* exported mc_get_order */


/* global $ */
/* global mc_sdk_param */
/* global obj_item */
/* global obj_lang_map */
/* global mc_ui_checkbox */
/* global arr_all_sel */
/* global obj_box_name */
/* global arr_order */
/* global mc_main_alert_popout */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    解析大屏界面数据
 * 参数:
 *    @param { Promise<object> } obj 下发参数
 * 返回:
 *    @returns  { Promise<object> } obj_return 下发参数
 * 例子:
 *    NA
 * 备注:
 *    解析界面dom元素 获取 偏移/接收卡名称/箱体名称
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2022.01.21
 *       内容 : 所有代码
************************************************************************************************/
function mc_get_box(obj) {
    var str_key = "";
    var str_each_key = "";
    var str_box_name = "";
    var obj_return = {};

    for (var key in obj) {
        if (0 === obj[key].length) {
            continue;
        }

        // 解析key  //0:0:0:0
        str_key = mc_deal_screen_order(key);
        var arr_each_recv_data = obj[key];
        var ui_each_recv_data_length = arr_each_recv_data.length;

        // 获取当前位置下所有接收卡数据
        for (var idx = 0; idx < ui_each_recv_data_length; idx++) {
            str_each_key = str_key + ":" + idx;
            // 箱体dom对象 第一层
            var html_dom_each = arr_each_recv_data[idx][0];

            str_box_name = html_dom_each.getAttribute("mod_id");
            // 箱体dom对象 第二层 偏移/接收卡名称

            obj_return[str_each_key] = {
                "str_box_name": str_box_name
            };
        }
    }

    return obj_return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理大屏界面位置指令
 * 参数:
 *    @param { Promise<string> } str 大屏位置指令
 * 返回:
 *    @returns  { Promise<string> } str_data 解析后的大屏指令
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2022.01.21
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_screen_order(str) {
    var str_data = str.replace(/[a-zA-Z]/g, "");
    var arr_data = [];
    var arr_hub_data = [];

    if (str_data.includes("_")) {
        arr_data = str_data.split("_");
        arr_hub_data = arr_data[2].split(":");
        str_data = (Number(arr_data[0]) - 1) + ":" + (Number(arr_data[1]) - 1) + ":" + (Number(arr_hub_data[0]) - 1) + ":" + (Number(arr_hub_data[1]) - 1);
    } else {
        arr_data = str_data.split(":");
        str_data = (Number(arr_data[0]) - 1) + ":" + (Number(arr_data[1]) - 1) + ":-1:-1";
    }

    return str_data;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    初始化界面
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2022.01.21
 *       内容 : 所有代码
************************************************************************************************/
function mc_init() {
    var arr_item = ["MC_LANG_BTN_SCREEN_SENDING_CARD", "MC_LANG_RECEIVER_SEND_PORT", "MC_LANG_HUB_CARD", "MC_LANG_HUB_PORT", "MC_LANG_RECEIVER_CARD"];

    // var arr_all_obj = [];

    var obj_init = new mc_sdk_param();

    for (var idx = 0; 5 > idx; idx++) {
        obj_init.set_param_value(arr_item[idx], "1");
        obj_init.set_attr_val(arr_item[idx], "UI_TYPE", "STEP_EDIT");
        obj_init.set_attr_val(arr_item[idx], "STEP", "1");
        obj_init.set_attr_val(arr_item[idx], "MIN_VAL", "1");
        obj_init.set_attr_val(arr_item[idx], "VAL_TYPE", "uint");
    }


    obj_item.set_rgb_combo_mode({
        "MC_LANG_BTN_SCREEN_SENDING_CARD": true,
        "MC_LANG_RECEIVER_SEND_PORT": true,
        "MC_LANG_HUB_CARD": true,
        "MC_LANG_HUB_PORT": true,
        "MC_LANG_RECEIVER_CARD": true
    });
    obj_item.set_lang_map(obj_lang_map);
    obj_item.set_max_col_cnt(1);
    obj_item.set_item_unit_width("30px");


    obj_item.set_json_txt(obj_init.get_json());
    $(".top").html(obj_item.get_dom_html());

    // console.log($(".item_gp_unit"));
    $.each($(".item_gp_unit"), function (index, ele) {
        var obj_check = new mc_ui_checkbox();
        var str_chg = ("check" + index);

        // str_chg = eval(str_chg);
        obj_check.on_val_chg = window[str_chg];
        obj_check.set_style_width("80px");
        obj_check.set_style_height("30px");

        obj_check.set_text(["MC_LANG_LOAD_ALL", "MC_LANG_LOAD_SINGLE"]);
        obj_check.set_val(arr_all_sel[index]);
        ele.innerHTML = obj_check.get_html_txt();
        ele.style.width = "90px";
    });
}

/* --------------------------------------------控制是否发全部------------------------------------------------- */
function check0(id, val) {
    arr_all_sel[0] = val;
    mc_show_item(0, val);
}
function check1(id, val) {
    arr_all_sel[1] = val;
    mc_show_item(1, val);
}
function check2(id, val) {
    arr_all_sel[2] = val;
    mc_show_item(2, val);
}
function check3(id, val) {
    arr_all_sel[3] = val;
    mc_show_item(3, val);
}
function check4(id, val) {
    arr_all_sel[4] = val;
    mc_show_item(4, val);
}

/* --------------------------------------------控制是否发全部------------------------------------------------- */

function mc_show_item(id, val) {
    var jq_dom = $($(".mc_igp_item_container ")[id]);

    if (val) {
        jq_dom.css({ "opacity": "0.2", "pointer-events": "none" });
    } else {
        jq_dom.css({ "opacity": "1", "pointer-events": "unset" });
    }
}

function mc_get_order() {
    var str_json = obj_item.get_json_txt();

    var obj_order = new mc_sdk_param();

    obj_order.set_param_clear();
    obj_order.set_json(str_json);

    var idx_s = obj_order.get_param_value("MC_LANG_BTN_SCREEN_SENDING_CARD");
    var idx_s_p = obj_order.get_param_value("MC_LANG_RECEIVER_SEND_PORT");
    var idx_h = obj_order.get_param_value("MC_LANG_HUB_CARD");
    var idx_h_p = obj_order.get_param_value("MC_LANG_HUB_PORT");
    var idx_r = obj_order.get_param_value("MC_LANG_RECEIVER_CARD");

    idx_s = (Number(idx_s) - 1) + "";
    idx_s_p = (Number(idx_s_p) - 1) + "";
    idx_h = (Number(idx_h) - 1) + "";
    idx_h_p = (Number(idx_h_p) - 1) + "";
    idx_r = (Number(idx_r) - 1) + "";

    arr_order = [idx_s, idx_s_p, idx_h, idx_h_p, idx_r];
    for (var idx = 0; 5 > idx; idx++) {
        if (arr_all_sel[idx]) {
            arr_order[idx] = "-1";
        }
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送数据
 * 参数:
 *    NA
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2022.01.21
 *       内容 : 所有代码
************************************************************************************************/
function mc_send() {
    if (0 === Object.keys(obj_box_name).length) {
        mc_main_alert_popout(obj_lang_map.MC_LANG_RESET_CONGULATE_NO_BOX_SEND, "", true);
        return;
    }
    parent.mc_loading_wait();
    mc_get_order();
    // 获取指令

    // 所有箱体和筛选的箱体
    var obj_right_box = JSON.parse(JSON.stringify(obj_box_name));
    var obj_all_box = JSON.parse(JSON.stringify(obj_box_name));

    var arr_send = mc_get_send_val(obj_right_box, false);
    var arr_all = mc_get_send_val(obj_all_box, true);

    if (0 === arr_send.length) {
        parent.mc_loading_wait_remove();
        mc_main_alert_popout(obj_lang_map.MC_LANG_RESET_CONGULATE_NO_BOX_SEND, "", true);
        return;
    }
    var str_close = mc_get_pix_json(false, arr_all);

    mc_send_pix(str_close, function () {
        var str_send = mc_get_pix_json(true, arr_send);

        mc_send_pix(str_send, function () {
            parent.mc_loading_wait_remove();
            mc_main_alert_popout("MC_LANG_SNED_SUCCESS", "", true);
            return true;
        });
    });
}

// 获取对应的已选的和所有箱体的指令
function mc_get_send_val(obj_data, b_val) {
    var obj_send = {};

    if (!b_val) {
        for (var id = 0; 5 > id; id++) {
            var idx = arr_order[id];

            if ("-1" === idx) {
                continue;
            }
            for (var key in obj_data) {
                if (Object.hasOwnProperty.call(obj_data, key)) {
                    var each_val = key.split(":")[id];

                    if (idx !== each_val) {
                        obj_data[key] = null;
                    }
                }
            }
        }

        // 根据指令获取对应箱体名称
        for (var key_o in obj_data) {
            if (Object.hasOwnProperty.call(obj_data, key_o)) {
                if (!obj_data[key_o]) {
                    continue;
                }

                obj_send[key_o] = obj_data[key_o];
            }
        }
    } else {
        obj_send = JSON.parse(JSON.stringify(obj_data));
    }

    var obj_final = {};

    // 将相同的箱体进行排序
    for (var key_j in obj_send) {
        if (Object.hasOwnProperty.call(obj_send, key_j)) {
            var str_box_name = obj_send[key_j].str_box_name;

            if (obj_final[str_box_name]) {
                obj_final[str_box_name].push(key_j);
            } else {
                obj_final[str_box_name] = [key_j];
            }
        }
    }
    return Object.entries(obj_final);
}

// 获取下发数据
function mc_get_pix_json(b_val, arr_data) {
    var obj_req = new mc_sdk_param();

    obj_req.set_param_clear();
    obj_req.set_func("PIX_SWITCH");
    obj_req.set_cmd("SET_PARAM");
    var ui_len = arr_data.length;
    // 运算符合条件的指令
    var str_box = "";
    var arr_each = "";
    var ui_len_o = "";
    var each_val = "";


    var str_key_val = "";
    var str_attr_val = "";

    if (!b_val) {
        str_attr_val = "(0:-1:-1:-1)";

        // 关闭所有
        // 可能只有一种箱体 或者两种箱体
        if (1 === ui_len) {
            str_key_val = "(-1:-1:-1:-1:-1)";
            str_box = arr_data[0][0];
            obj_req.set_param_value(str_box, str_key_val);
            obj_req.set_attr_val(str_box, "CMD", str_attr_val);
        } else {
            for (var id = 0; id < ui_len; id++) {
                str_box = arr_data[id][0];
                arr_each = arr_data[id][1];
                ui_len_o = arr_each.length;
                str_key_val = "";
                for (var id_o = 0; id_o < ui_len_o; id_o++) {
                    each_val = arr_each[id_o];

                    each_val = "(" + each_val + "),";
                    str_key_val += each_val;
                }
                str_key_val = str_key_val.slice(0, -1);

                obj_req.set_param_value(str_box, str_key_val);
                obj_req.set_attr_val(str_box, "CMD", str_attr_val);
            }
        }
    } else {
        // 点亮筛选
        str_attr_val = "(255:-1:-1:-1)";
        for (var key = 0; key < ui_len; key++) {
            str_box = arr_data[key][0];
            arr_each = arr_data[key][1];
            ui_len_o = arr_each.length;
            str_key_val = "";
            for (var key_o = 0; key_o < ui_len_o; key_o++) {
                each_val = arr_each[key_o];

                each_val = "(" + each_val + "),";
                str_key_val += each_val;
            }
            str_key_val = str_key_val.slice(0, -1);

            obj_req.set_param_value(str_box, str_key_val);
            obj_req.set_attr_val(str_box, "CMD", str_attr_val);
        }
    }


    return obj_req.get_json();
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    发送箱体像素控制信息
 * 参数:
 *    @param {Promise<Array>} str_data 可下发的箱体数据
 *    @param {Promise<function>} fun_callback 传入回调函数
 * 返回：
 *    NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时间 : 2022.01.21
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_send_pix(str_data, fun_callback) {
    if ("function" !== typeof (fun_callback)) {
        return;
    }
    $.post("/access_shell", str_data, function (response, status) {
        if ("success" !== status) {
            fun_callback("");
            return;
        }
        fun_callback();
    });
}
